/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.dimension;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_32;
import net.minecraft.class_5285;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_32.class})
public class LevelStorageBugfixMixin {
    @Inject(method={"readGeneratorProperties"}, at={@At(value="HEAD")})
    private static <T> void onReadGeneratorProperties(Dynamic<T> nbt, DataFixer dataFixer, int version, CallbackInfoReturnable<Pair<class_5285, Lifecycle>> cir) {
        class_2520 nbtTag = (class_2520)nbt.getValue();
        class_2487 worldGenSettings = ((class_2487)nbtTag).method_10562("WorldGenSettings");
        LevelStorageBugfixMixin.removeNonVanillaDimensionsFromWorldGenSettingsTag(worldGenSettings);
    }

    @Unique
    private static void removeNonVanillaDimensionsFromWorldGenSettingsTag(class_2487 worldGenSettings) {
        String[] vanillaDimensionIds = new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"};
        class_2487 dimensions = worldGenSettings.method_10562("dimensions");
        if (dimensions.method_10546() > vanillaDimensionIds.length) {
            class_2487 newDimensions = new class_2487();
            for (String dimId : vanillaDimensionIds) {
                if (!dimensions.method_10545(dimId)) continue;
                newDimensions.method_10566(dimId, (class_2520)dimensions.method_10562(dimId));
            }
            worldGenSettings.method_10566("dimensions", (class_2520)newDimensions);
        }
    }
}

